% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_metadata.R
\name{gen_metadata}
\alias{gen_metadata}
\title{Search For Meta-Information For All Types Of Objects}
\usage{
gen_metadata(
  code = NULL,
  database = c("all", "genesis", "zensus", "regio"),
  category = c("cube", "statistic", "table", "variable", "value"),
  area = c("all", "public", "user"),
  error.ignore = FALSE,
  verbose = TRUE,
  raw = FALSE,
  ...
)
}
\arguments{
\item{code}{String with a maximum length of 15 characters for a database object (GENESIS, regionalstatistik.de, Zensus 2022). Only one code per iteration.}

\item{database}{Character string. Indicator if the GENESIS ('genesis'), Zensus 2022 ('zensus') or regionalstatistik.de ('regio') database is called. Default option is 'all'.}

\item{category}{Character string. Specifying the specific object type of the object that you want meta data for. No default option - you need to specify the object type. Hint: The functions in 'restatis' often return information on object 'Type'.}

\item{area}{Character string. Indicator from which area of the database the results are called. In general, 'all' is the appropriate solution. Default option is 'all'. Not used for 'statistics'.}

\item{error.ignore}{Boolean. Indicator if the function should stop if an error occurs or no object for the request is found or if it should produce a token as response. Default option is 'FALSE'. Important note: This does not apply to errors generated by the API call itself (especially server or client errors with status codes 5xx or 4xx). In this case, the function call will error even if error.ignore is set to TRUE.}

\item{verbose}{Boolean. Indicator if the output of the function should include detailed messages and warnings. Default option is 'TRUE'. Set the parameter to 'FALSE' to suppress additional messages and warnings.}

\item{raw}{Boolean. Should a non-parsed API response be returned? Default option is 'FALSE'.}

\item{...}{Additional parameters for the API call. These parameters are only affecting the call itself, no further processing. For more details see \code{vignette("additional_parameter")}.}
}
\value{
A list with all recalled elements from the API. Attributes are added to the data.frame describing the search configuration for the returned output.
}
\description{
Search for metadata-information for all types of objects and databases and have them returned as a list.
}
\examples{
\dontrun{
# Find meta-information of the table with the code "11111"
object <- gen_metadata(code = "11111", category = "table", database = "genesis")
}

}
