% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_clean.R
\name{ee_clean_user_credentials}
\alias{ee_clean_user_credentials}
\title{Clean credentials for a specific user}
\usage{
ee_clean_user_credentials(
  user = NULL,
  earthengine = TRUE,
  drive = TRUE,
  gcs = FALSE
)
}
\arguments{
\item{user}{Character (optional, e.g. \code{data.colec.fbf}). The user
to remove credentials (See \code{~/.config/earthengine/}). A 'user' represents
a set of credentials that certificate a specific Google identity.}

\item{earthengine}{Logical. Earthengine credential.}

\item{drive}{Logical. Google Drive credential.}

\item{gcs}{Logical. Google Cloud Storage credential.}
}
\value{
No return value, called for cleaning the path \code{~/.config/earthengine/}
}
\description{
Clean credentials for a specific user
}
\examples{
\dontrun{
library(rgee)

# Delete caducated credentials for a specific user
ee_clean_user_credentials(earthengine=TRUE, drive=TRUE)
ee_users()
}
}
\seealso{
Other ee_clean functions: 
\code{\link{ee_clean_container}()},
\code{\link{ee_clean_pyenv}()}
}
\concept{ee_clean functions}
