% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{gd_properties}
\alias{gd_properties}
\title{Get Properties of an Image Collection}
\usage{
gd_properties(x)
}
\arguments{
\item{x}{A \code{geedim.collection.ImageCollectionAccessor} (for geedim >= 2.0.0) or \code{geedim.collection.MaskedCollection} (for geedim < 2.0.0) object. See \verb{\link{geedim-versions}} for more details.}
}
\value{
\code{data.frame} containing properties table from \code{x}; \code{NULL} if no properties table.
}
\description{
Get Properties of an Image Collection
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("R_RGEEDIM_RUN_EXAMPLES"))) && gd_is_initialized() && !inherits(requireNamespace("terra", quietly=TRUE), 'try-error')) withAutoprint(\{ # examplesIf}
\donttest{
library(terra)

b <- terra::vect('POLYGON((-121.355 37.560, 
                           -121.355 37.555,
                           -121.350 37.555, 
                           -121.350 37.560,
                           -121.355 37.560))',
                 crs = "OGC:CRS84")

if (gd_is_initialized()) {
  x <- gd_search(gd_collection_from_name("USGS/3DEP/1m"),
                 region = gd_region(b))
  gd_properties(x)
}
}
\dontshow{\}) # examplesIf}
}
