% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{head.gexf}
\alias{head.gexf}
\title{\code{head} method for gexf objects}
\usage{
\method{head}{gexf}(x, n_nodes = 6L, n_edges = n_nodes, ...)
}
\arguments{
\item{x}{An object of class \link{gexf}.}

\item{n_nodes, n_edges}{Integers. Number of nodes and edges to print}

\item{...}{Ignored}
}
\description{
List the first \code{n_nodes} and \code{n_edges} of the \link{gexf} file.
}
\examples{
fn <- system.file("gexf-graphs/lesmiserables.gexf", package = "rgexf")
g  <- read.gexf(fn)
head(g, n_nodes = 5)
}
