% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rocheCompound.R
\name{shortenRocheCompoundID}
\alias{shortenRocheCompoundID}
\title{Shorten Roche compounds identifiers}
\usage{
shortenRocheCompoundID(str)
}
\arguments{
\item{str}{Character strings that contains one or more Roche core identifiers (\code{RO} followed by seven-digit numbers)}
}
\value{
Character strings of the same length as the input, with all core identifiers shortened

In contrast to \code{\link{rocheCore}}, which only handles character strings that are valid Roche compound identifiers, this function takes any input
string and performs a \code{gsub} operation to shorten Roche core numbers. Therefore, it even works when only a substring matches the pattern of a Roche compound name.
}
\description{
Shorten Roche compounds identifiers
}
\examples{
shortenRocheCompoundID(c("RO1234567-001", "RO1234567-001-000", 
"RO1234567", "ROnoise-001", "anyOther-not-affected", 
"RO1234567 and RO9876543 are two imaginary compounds."))
}
