% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_fields.R
\name{christoffel}
\alias{christoffel}
\title{Christoffel symbols}
\usage{
christoffel(g)
}
\arguments{
\item{g}{A covariant metric tensor, a "metric_field" object. See \code{\link[=metric_field]{metric_field()}}
to create a new metric tensor, or use predefined metrics,
e.g. \code{\link[=g_eucl_cart]{g_eucl_cart()}}.}
}
\value{
Returns the Christoffel symbols of the first kind \eqn{\Gamma_{ijk}}
as rank 3 \code{\link[=array]{array()}}.
}
\description{
Provides the Christoffel symbols of the first kind \eqn{\Gamma_{ijk}} with
respect to the Levi Civita connection for a given metric tensor.
}
\details{
The Christoffel symbols are a rank 3 array of numbers.
}
\examples{
christoffel(g_eucl_sph(3))
}
\seealso{
Wikipedia: \href{https://en.wikipedia.org/wiki/Christoffel_symbols}{Christoffel symbols}

Other geometric tensors: 
\code{\link{ricci}()},
\code{\link{ricci_sc}()},
\code{\link{riemann}()}
}
\concept{geom_tensors}
\concept{geometric tensors}
