% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-env.R
\name{new_src_tbl}
\alias{new_src_tbl}
\alias{is_src_tbl}
\alias{as_src_tbl}
\alias{as_src_tbl.src_env}
\alias{new_src_env}
\alias{is_src_env}
\alias{as.list.src_env}
\alias{as_src_env}
\alias{attached_srcs}
\alias{is_tbl_avail}
\alias{src_tbl_avail}
\alias{src_data_avail}
\alias{is_data_avail}
\title{Data source environments}
\usage{
new_src_tbl(files, col_cfg, tbl_cfg, prefix, src_env)

is_src_tbl(x)

as_src_tbl(x, ...)

\method{as_src_tbl}{src_env}(x, tbl, ...)

new_src_env(x, env = new.env(parent = data_env()), link = NULL)

is_src_env(x)

\method{as.list}{src_env}(x, ...)

as_src_env(x)

attached_srcs()

is_tbl_avail(tbl, env)

src_tbl_avail(env, tbls = ls(envir = env))

src_data_avail(src = auto_attach_srcs())

is_data_avail(src = auto_attach_srcs())
}
\arguments{
\item{files}{File names of \code{fst} files that will be used to create a \code{prt}
object (see also \code{\link[prt:new_prt]{prt::new_prt()}})}

\item{col_cfg}{Coerced to \code{col_cfg} by calling \code{\link[=as_col_cfg]{as_col_cfg()}}}

\item{tbl_cfg}{Coerced to \code{tbl_cfg} by calling \code{\link[=as_tbl_cfg]{as_tbl_cfg()}}}

\item{prefix}{Character vector valued data source name(s) (used as class
prefix)}

\item{src_env}{The data source environment (as \code{src_env} object)}

\item{x}{Object to test/coerce}

\item{tbl}{String-valued table name}

\item{env}{Environment used as \code{src_env}}

\item{link}{\code{NULL} or a second environment (in addition to \code{data_env()}) in
which the resulting \code{src_env} is bound to a name}

\item{tbls}{Character vector of table names}

\item{src}{Character vector of data source names or any other object (or
list thereof) for which an \code{as_src_env()} method exists}
}
\value{
The constructors \code{new_src_env()}/\code{new_src_tbl()} as well as coercion
functions \code{as_src_env()}/\code{as_src_tbl()} return \code{src_env} and \code{src_tbl}
objects respectively, while inheritance testers \code{is_src_env()}/
\code{is_src_tbl()} return logical flags. For data availability utilities, see
Details section.
}
\description{
Attaching a data source (see \code{\link[=attach_src]{attach_src()}}) instantiates two types of S3
classes: a single \code{src_env} object, representing the data source as
collection of tables, as well as a \code{src_tbl} objects per table,
representing the given table. Upon package loading, \code{src_env} objects
including the respective \code{src_tbl} objects are created for all data sources
that are configured for auto-attaching, irrespective of whether data is
actually available. If some (or all) data is missing, the user is asked for
permission to download in interactive sessions and an error is thrown in
non-interactive sessions. See \code{\link[=setup_src_env]{setup_src_env()}} for manually downloading
and setting up data sources.
}
\details{
A \code{src_env} object is an environment with attributes \code{src_name} (a
string-valued data source name, such as \code{mimic_demo}) and \code{id_cfg}
(describing the possible patient IDs for the given data source). In
addition to the \code{src_env} class attribute, sub-classes are defined by the
source \code{class_prefix} configuration setting (see \code{\link[=load_src_cfg]{load_src_cfg()}}). Such
data source environments are intended to contain several corresponding
\code{src_tbl} objects (or rather active bindings that evaluate to \code{src_tbl}
objects; see \code{\link[=setup_src_env]{setup_src_env()}}).

The S3 class \code{src_tbl} inherits from \code{\link[prt:new_prt]{prt}}, which
represents a partitioned \code{\link[fst:fst]{fst}} file. In addition to the \code{prt}
object, meta data in the form of \code{col_cfg} and \code{tbl_cfg} is associated with
a \code{src_tbl} object (see \code{\link[=load_src_cfg]{load_src_cfg()}}). Furthermore, sub-classes are
added as specified by the source configuration \code{class_prefix} entry, as
with \code{src_env} objects. This allows certain functionality, for example data
loading, to be adapted to data source-specific requirements.

Instantiation and set up of \code{src_env} objects is possible irrespective of
whether the underlying data is available. If some (or all) data is missing,
the user is asked for permission to download in interactive sessions and an
error is thrown in non-interactive sessions upon first access of a
\code{src_tbl} bound as set up by \code{\link[=setup_src_env]{setup_src_env()}}. Data availability can be
checked with the following utilities:
\itemize{
\item \code{is_tbl_avail()}: Returns a logical flag indicating whether all required
data for the table passed as \code{tbl} which may be a string or any object
that has a \code{tbl_name()} implementation is available from the environment
\code{env} (requires an \code{as_src_env()} method).
\item \code{src_tbl_avail()}: Returns a named logical vector, indicating which tables
have all required data available. As above, both \code{tbls} (arbitrary
length) and \code{env} (scalar-valued) may be character vectors or objects
with corresponding \code{tbl_name()} and \code{as_src_env()} methods.
\item \code{src_data_avail()}: The most comprehensive data availability report can
be generated by calling \code{src_data_avail()}, returning a \code{data.frame} with
columns \code{name} (the data source name), \code{available} (logical vector
indicating whether all data is available), \code{tables} (the number of
available tables) and \code{total} (the total number of tables). As input,
\code{src} may be an arbitrary length character vector, an object for which an
\code{as_src_env()} method is defined or an arbitrary-length list thereof.
\item \code{is_data_avail()}: Returns a named logical vector, indicating for which
data sources all required data is available. As above, \code{src} may be an
arbitrary length character vector, an object for which an \code{as_src_env()}
method is defined or an arbitrary-length list thereof.
}
}
\keyword{internal}
