% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/news.R
\name{riingo_news}
\alias{riingo_news}
\title{Get news articles cultivated by Tiingo}
\usage{
riingo_news(
  ticker = NULL,
  start_date = NULL,
  end_date = NULL,
  tags = NULL,
  source = NULL,
  limit = 100,
  offset = 0
)
}
\arguments{
\item{ticker}{One or more tickers to download data for from Tiingo. Can be a
stock, mutual fund, or ETF. A character vector.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}

\item{tags}{A character vector of one word tags to filter with, such as
\code{"Election"} or \code{"Australia"}.}

\item{source}{A character vector of URLs corresponding to news sources to
collect articles from (such as \code{"bloomberg.com"} or \code{"seekingalpha.com"}).}

\item{limit}{The maximum number of articles to be retrieved.
The default is 100, the maximum is 1000.}

\item{offset}{A single integer representing the "pagination". This is
generally used in combination with \code{limit} to retrieve more articles.
For example, if \code{limit = 100}, you can request the first 100 articles. If
\code{offset} is then set to \code{100}, you can request again to get the next 100
articles.}
}
\description{
This function retrieves news articles filtered by tickers, tags, or sources.
It returns them as a data frame with one row per article. The original URL
to the article, its description, and a number of other features are
returned.
}
\details{
Returns a data frame of news article descriptions, urls, sources, and more.
}
\examples{
\dontrun{
riingo_news(ticker = "QQQ")

# Filter by either source URL or tag
riingo_news(ticker = "QQQ", source = "bloomberg.com")
riingo_news(ticker = "QQQ", tags = "Earnings")

# A ticker is not required
riingo_news(tags = "Earnings")
}
}
