% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_pipeline.R
\name{rxp_pipeline}
\alias{rxp_pipeline}
\title{Create a named pipeline of derivations}
\usage{
rxp_pipeline(name, path, color = NULL, ...)
}
\arguments{
\item{name}{Character, the name of the pipeline (e.g., "ETL", "Model").}

\item{path}{Character path to an R script returning a list of derivations, OR
a list of derivation objects created by \code{rxp_r()}, \code{rxp_py()}, etc.}

\item{color}{Character, optional. A CSS color name (e.g., "darkorange") or
hex code (e.g., "#FF5733") to use for this pipeline's nodes in DAG
visualizations. If NULL, a default color will be assigned.}

\item{...}{Additional arguments (currently unused, reserved for future use).}
}
\value{
An object of class \code{rxp_pipeline} containing the derivations with
pipeline metadata attached.
}
\description{
Groups multiple derivations into a named pipeline for organizational
purposes. This allows you to structure large projects into logical
sub-pipelines (e.g., "ETL", "Model", "Report") that are visually
distinguished in DAG visualizations.
}
\details{
The \code{rxp_pipeline()} function is used to organize derivations into logical
groups. When passed to \code{rxp_populate()}, the derivations are flattened but
retain their group and color metadata, which is then used in DAG
visualizations (\code{rxp_visnetwork()} and \code{rxp_ggdag()}) to distinguish
different parts of your workflow.

This pattern enables a "Master Script" workflow where you can define
sub-pipelines in separate R scripts that each return a list of derivations.
You then pass the paths to these scripts to \code{rxp_pipeline()}:
}
\examples{
\dontrun{
  # Define derivations in separate scripts
  # pipelines/01_etl.R returns: list(rxp_r(...), rxp_r(...))
  # pipelines/02_model.R returns: list(rxp_r(...), rxp_r(...))

  # Master script (run.R):

  # Create named pipelines with colors by pointing to the files
  pipe_etl <- rxp_pipeline("ETL", "pipelines/01_etl.R", color = "darkorange")
  pipe_model <- rxp_pipeline("Model", "pipelines/02_model.R", color = "dodgerblue")

  # Build the combined pipeline
  rxp_populate(list(pipe_etl, pipe_model))
  rxp_make()

  # Visualize - ETL nodes will be orange, Model nodes will be blue
  rxp_visnetwork()
}

}
\seealso{
Other pipeline functions: 
\code{\link{rxp_make}()},
\code{\link{rxp_populate}()}
}
\concept{pipeline functions}
