% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{intervention_variable}
\alias{intervention_variable}
\title{Intervention variable}
\usage{
intervention_variable(
  frequency,
  start,
  length,
  s,
  starts,
  ends,
  delta = 0,
  seasonaldelta = 0
)
}
\arguments{
\item{frequency}{Frequency of the series, number of periods per year
(12, 4, 3, 2...)}

\item{start, length}{First date (array with the first year and the first
period, for instance \code{c(1980, 1)}) and number of periods of the output
variables. Can also be provided with the \code{s} argument}

\item{s}{time series used to get the dates for the trading days variables.
If supplied the parameters \code{frequency}, \code{start} and \code{length} are ignored.}

\item{starts, ends}{characters specifying sequences of starts/ends dates for the intervention variable.
Can be characters or integers.}

\item{delta}{regular differencing order.}

\item{seasonaldelta}{seasonal differencing order.}
}
\value{
a \code{ts} object
}
\description{
Function allowing to create external regressors as sequences of zeros and ones. The generated variables
will have to be added with \code{\link{add_usrdefvar}} function will require a modelling context definition
with \code{\link{modelling_context}} to be used in an estimation process.
}
\details{
Intervention variables are combinations of any possible sequence of ones and zeros
(the sequence of ones being defined by the parameters \code{starts} and \code{ends})
and of \eqn{\frac{1}{(1-B)^d}} and \eqn{\frac{1}{(1-B^s)^D}} where \eqn{B} is the
backwards operator, \eqn{s} is the frequency of the time series,
\eqn{d} and \eqn{D} are the parameters \code{delta} and \code{seasonaldelta}.

For example, with \code{delta = 0} and \code{seasonaldelta = 0} we get temporary level shifts defined
by the parameters \code{starts} and \code{ends}. With \code{delta = 1} and \code{seasonaldelta = 0} we get
the cumulative sum of temporary level shifts, once differenced the regressor will become a classical level shift.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
iv1 <- intervention_variable(
    frequency = 12,
    start = c(2000, 1),
    length = 60,
    starts = "2001-01-01",
    ends = "2001-12-01"
)
plot(iv1)
iv2 <- intervention_variable(
    frequency = 12,
    start = c(2000, 1),
    length = 60,
    starts = "2001-01-01",
    ends = "2001-12-01",
    delta = 1
)
plot(iv2)

# Using one variable in a a seasonal adjustment process
# Regressors as a list of two groups reg1 and reg2
vars <- list(
    reg1 = list(x = iv1),
    reg2 = list(x = iv2)
)

# creating the modelling context
my_context <- modelling_context(variables = vars)

# customize a default specification
init_spec <- x13_spec_default
new_spec <- add_usrdefvar(init_spec, name = "reg1.iv1", regeffect = "Trend")
\dontshow{\}) # examplesIf}
}
\references{
More information on auxiliary variables in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/}
}
\seealso{
\code{\link{modelling_context}}, \code{\link{add_usrdefvar}}
}
