% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arima.R
\name{sarima_model}
\alias{sarima_model}
\title{Seasonal ARIMA model (Box-Jenkins)}
\usage{
sarima_model(
  name = "sarima",
  period,
  phi = NULL,
  d = 0,
  theta = NULL,
  bphi = NULL,
  bd = 0,
  btheta = NULL
)
}
\arguments{
\item{name}{name of the model.}

\item{period}{period of the model.}

\item{phi}{coefficients of the regular auto-regressive polynomial
(\eqn{1 + \phi_1B + \phi_2B + ...}). True signs.}

\item{d}{regular differencing order.}

\item{theta}{coefficients of the regular moving average polynomial
(\eqn{1 + \theta_1B + \theta_2B + ...}). True signs.}

\item{bphi}{coefficients of the seasonal auto-regressive polynomial. True
signs.}

\item{bd}{seasonal differencing order.}

\item{btheta}{coefficients of the seasonal moving average polynomial. True
signs.}
}
\value{
A \code{"JD3_SARIMA"} model.
}
\description{
Seasonal ARIMA model (Box-Jenkins)
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
mod1 <- sarima_model(period = 12, d = 1, bd = 1, theta = 0.2, btheta = 0.2)
\dontshow{\}) # examplesIf}
}
