/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import java.util.List;
import jdplus.sa.base.api.ComponentDescriptor;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.core.arima.ArimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SeatsResults
implements GenericExplorable {
    public static final ComponentDescriptor SeasonallyAdjusted = new ComponentDescriptor("sa", 1, false, true);
    public static final ComponentDescriptor Trend = new ComponentDescriptor("trend", 0, true, true);
    public static final ComponentDescriptor Seasonal = new ComponentDescriptor("seasonal", 1, true, false);
    public static final ComponentDescriptor Transitory = new ComponentDescriptor("transitory", 2, true, false);
    public static final ComponentDescriptor Irregular = new ComponentDescriptor("irregular", 3, true, false);
    public static final List<ComponentDescriptor> descriptors = Arrays2.unmodifiableList((Object[])new ComponentDescriptor[]{SeasonallyAdjusted, Trend, Seasonal, Transitory, Irregular});
    private static final ComponentDescriptor aIrregular = new ComponentDescriptor("irregular", 2, true, false);
    public static final List<ComponentDescriptor> airlineDescriptors = Arrays2.unmodifiableList((Object[])new ComponentDescriptor[]{SeasonallyAdjusted, Trend, Seasonal, aIrregular});
    private final SarimaModel originalModel;
    private final SarimaModel finalModel;
    private final double innovationVariance;
    private final boolean meanCorrection;
    private final boolean parametersCutOff;
    private final boolean modelChanged;
    private final UcarimaModel ucarimaModel;
    private final UcarimaModel compactUcarimaModel;
    private final SeriesDecomposition initialComponents;
    private final SeriesDecomposition finalComponents;

    public static String[] getComponentsName(UcarimaModel ucm) {
        List<ComponentDescriptor> d = ucm.getComponentsCount() == 4 ? descriptors : airlineDescriptors;
        String[] names = new String[d.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = d.get(i).getName();
        }
        return names;
    }

    public static ArimaModel[] getComponents(UcarimaModel ucm) {
        List<ComponentDescriptor> d = ucm.getComponentsCount() == 4 ? descriptors : airlineDescriptors;
        ArimaModel[] cmps = new ArimaModel[d.size()];
        for (int i = 0; i < cmps.length; ++i) {
            cmps[i] = d.get(i).isSignal() ? ucm.getComponent(d.get(i).getComponent()) : ucm.getComplement(d.get(i).getComponent());
        }
        return cmps;
    }

    public TsDomain getBackcastDomain() {
        TsData sa = this.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast);
        return sa == null ? TsDomain.DEFAULT_EMPTY : sa.getDomain();
    }

    public TsDomain getForecastDomain() {
        TsData sa = this.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        return sa == null ? TsDomain.DEFAULT_EMPTY : sa.getDomain();
    }

    public TsDomain getActualDomain() {
        TsData sa = this.initialComponents.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
        return sa == null ? TsDomain.DEFAULT_EMPTY : sa.getDomain();
    }

    @Generated
    SeatsResults(SarimaModel originalModel, SarimaModel finalModel, double innovationVariance, boolean meanCorrection, boolean parametersCutOff, boolean modelChanged, UcarimaModel ucarimaModel, UcarimaModel compactUcarimaModel, SeriesDecomposition initialComponents, SeriesDecomposition finalComponents) {
        this.originalModel = originalModel;
        this.finalModel = finalModel;
        this.innovationVariance = innovationVariance;
        this.meanCorrection = meanCorrection;
        this.parametersCutOff = parametersCutOff;
        this.modelChanged = modelChanged;
        this.ucarimaModel = ucarimaModel;
        this.compactUcarimaModel = compactUcarimaModel;
        this.initialComponents = initialComponents;
        this.finalComponents = finalComponents;
    }

    @Generated
    public static @NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public SarimaModel getOriginalModel() {
        return this.originalModel;
    }

    @Generated
    public SarimaModel getFinalModel() {
        return this.finalModel;
    }

    @Generated
    public double getInnovationVariance() {
        return this.innovationVariance;
    }

    @Generated
    public boolean isMeanCorrection() {
        return this.meanCorrection;
    }

    @Generated
    public boolean isParametersCutOff() {
        return this.parametersCutOff;
    }

    @Generated
    public boolean isModelChanged() {
        return this.modelChanged;
    }

    @Generated
    public UcarimaModel getUcarimaModel() {
        return this.ucarimaModel;
    }

    @Generated
    public UcarimaModel getCompactUcarimaModel() {
        return this.compactUcarimaModel;
    }

    @Generated
    public SeriesDecomposition getInitialComponents() {
        return this.initialComponents;
    }

    @Generated
    public SeriesDecomposition getFinalComponents() {
        return this.finalComponents;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeatsResults)) {
            return false;
        }
        SeatsResults other = (SeatsResults)o;
        if (Double.compare(this.getInnovationVariance(), other.getInnovationVariance()) != 0) {
            return false;
        }
        if (this.isMeanCorrection() != other.isMeanCorrection()) {
            return false;
        }
        if (this.isParametersCutOff() != other.isParametersCutOff()) {
            return false;
        }
        if (this.isModelChanged() != other.isModelChanged()) {
            return false;
        }
        SarimaModel this$originalModel = this.getOriginalModel();
        SarimaModel other$originalModel = other.getOriginalModel();
        if (this$originalModel == null ? other$originalModel != null : !this$originalModel.equals(other$originalModel)) {
            return false;
        }
        SarimaModel this$finalModel = this.getFinalModel();
        SarimaModel other$finalModel = other.getFinalModel();
        if (this$finalModel == null ? other$finalModel != null : !this$finalModel.equals(other$finalModel)) {
            return false;
        }
        UcarimaModel this$ucarimaModel = this.getUcarimaModel();
        UcarimaModel other$ucarimaModel = other.getUcarimaModel();
        if (this$ucarimaModel == null ? other$ucarimaModel != null : !this$ucarimaModel.equals(other$ucarimaModel)) {
            return false;
        }
        UcarimaModel this$compactUcarimaModel = this.getCompactUcarimaModel();
        UcarimaModel other$compactUcarimaModel = other.getCompactUcarimaModel();
        if (this$compactUcarimaModel == null ? other$compactUcarimaModel != null : !this$compactUcarimaModel.equals(other$compactUcarimaModel)) {
            return false;
        }
        SeriesDecomposition this$initialComponents = this.getInitialComponents();
        SeriesDecomposition other$initialComponents = other.getInitialComponents();
        if (this$initialComponents == null ? other$initialComponents != null : !this$initialComponents.equals(other$initialComponents)) {
            return false;
        }
        SeriesDecomposition this$finalComponents = this.getFinalComponents();
        SeriesDecomposition other$finalComponents = other.getFinalComponents();
        return !(this$finalComponents == null ? other$finalComponents != null : !this$finalComponents.equals(other$finalComponents));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $innovationVariance = Double.doubleToLongBits(this.getInnovationVariance());
        result = result * 59 + (int)($innovationVariance >>> 32 ^ $innovationVariance);
        result = result * 59 + (this.isMeanCorrection() ? 79 : 97);
        result = result * 59 + (this.isParametersCutOff() ? 79 : 97);
        result = result * 59 + (this.isModelChanged() ? 79 : 97);
        SarimaModel $originalModel = this.getOriginalModel();
        result = result * 59 + ($originalModel == null ? 43 : $originalModel.hashCode());
        SarimaModel $finalModel = this.getFinalModel();
        result = result * 59 + ($finalModel == null ? 43 : $finalModel.hashCode());
        UcarimaModel $ucarimaModel = this.getUcarimaModel();
        result = result * 59 + ($ucarimaModel == null ? 43 : $ucarimaModel.hashCode());
        UcarimaModel $compactUcarimaModel = this.getCompactUcarimaModel();
        result = result * 59 + ($compactUcarimaModel == null ? 43 : $compactUcarimaModel.hashCode());
        SeriesDecomposition $initialComponents = this.getInitialComponents();
        result = result * 59 + ($initialComponents == null ? 43 : $initialComponents.hashCode());
        SeriesDecomposition $finalComponents = this.getFinalComponents();
        result = result * 59 + ($finalComponents == null ? 43 : $finalComponents.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "SeatsResults(originalModel=" + String.valueOf(this.getOriginalModel()) + ", finalModel=" + String.valueOf(this.getFinalModel()) + ", innovationVariance=" + this.getInnovationVariance() + ", meanCorrection=" + this.isMeanCorrection() + ", parametersCutOff=" + this.isParametersCutOff() + ", modelChanged=" + this.isModelChanged() + ", ucarimaModel=" + String.valueOf(this.getUcarimaModel()) + ", compactUcarimaModel=" + String.valueOf(this.getCompactUcarimaModel()) + ", initialComponents=" + String.valueOf(this.getInitialComponents()) + ", finalComponents=" + String.valueOf(this.getFinalComponents()) + ")";
    }

    @Generated
    public static class Builder {
        @Generated
        private SarimaModel originalModel;
        @Generated
        private SarimaModel finalModel;
        @Generated
        private double innovationVariance;
        @Generated
        private boolean meanCorrection;
        @Generated
        private boolean parametersCutOff;
        @Generated
        private boolean modelChanged;
        @Generated
        private UcarimaModel ucarimaModel;
        @Generated
        private UcarimaModel compactUcarimaModel;
        @Generated
        private SeriesDecomposition initialComponents;
        @Generated
        private SeriesDecomposition finalComponents;

        @Generated
        Builder() {
        }

        @Generated
        public @NonNull Builder originalModel(SarimaModel originalModel) {
            this.originalModel = originalModel;
            return this;
        }

        @Generated
        public @NonNull Builder finalModel(SarimaModel finalModel) {
            this.finalModel = finalModel;
            return this;
        }

        @Generated
        public @NonNull Builder innovationVariance(double innovationVariance) {
            this.innovationVariance = innovationVariance;
            return this;
        }

        @Generated
        public @NonNull Builder meanCorrection(boolean meanCorrection) {
            this.meanCorrection = meanCorrection;
            return this;
        }

        @Generated
        public @NonNull Builder parametersCutOff(boolean parametersCutOff) {
            this.parametersCutOff = parametersCutOff;
            return this;
        }

        @Generated
        public @NonNull Builder modelChanged(boolean modelChanged) {
            this.modelChanged = modelChanged;
            return this;
        }

        @Generated
        public @NonNull Builder ucarimaModel(UcarimaModel ucarimaModel) {
            this.ucarimaModel = ucarimaModel;
            return this;
        }

        @Generated
        public @NonNull Builder compactUcarimaModel(UcarimaModel compactUcarimaModel) {
            this.compactUcarimaModel = compactUcarimaModel;
            return this;
        }

        @Generated
        public @NonNull Builder initialComponents(SeriesDecomposition initialComponents) {
            this.initialComponents = initialComponents;
            return this;
        }

        @Generated
        public @NonNull Builder finalComponents(SeriesDecomposition finalComponents) {
            this.finalComponents = finalComponents;
            return this;
        }

        @Generated
        public @NonNull SeatsResults build() {
            return new SeatsResults(this.originalModel, this.finalModel, this.innovationVariance, this.meanCorrection, this.parametersCutOff, this.modelChanged, this.ucarimaModel, this.compactUcarimaModel, this.initialComponents, this.finalComponents);
        }

        @Generated
        public @NonNull String toString() {
            return "SeatsResults.Builder(originalModel=" + String.valueOf(this.originalModel) + ", finalModel=" + String.valueOf(this.finalModel) + ", innovationVariance=" + this.innovationVariance + ", meanCorrection=" + this.meanCorrection + ", parametersCutOff=" + this.parametersCutOff + ", modelChanged=" + this.modelChanged + ", ucarimaModel=" + String.valueOf(this.ucarimaModel) + ", compactUcarimaModel=" + String.valueOf(this.compactUcarimaModel) + ", initialComponents=" + String.valueOf(this.initialComponents) + ", finalComponents=" + String.valueOf(this.finalComponents) + ")";
        }
    }
}

