% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumspanningtree.R
\name{MinSpanningTree}
\alias{MinSpanningTree}
\title{Solver for Minimum Spanning Tree}
\usage{
MinSpanningTree(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  algorithm = "Kruskal"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of nodes of a
graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{algorithm}{Choices of algorithm include "Kruskal". "Kruskal" is the
default.}
}
\value{
A named list containing three entries: 1) "sources": a vector
  corresponding the source nodes of the edges in the tree, 2) "targets": a
  vector corresponding the target nodes of the edges in the tree, and 3)
  "value": the total minimum spanning tree value.
}
\description{
The minimum spanning tree is the minimal connected acyclic subgraph of a
graph, assuming the graph is undirected.
}
\details{
For details on LEMON's implementation, including differences between the
algorithms, see
\url{https://lemon.cs.elte.hu/pub/doc/1.3.1/a00610.html#ga233792b2c44a3581b85a775703e045af}
}
