% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.tau2.empirical.prior_function.R
\name{table_tau2_prior}
\alias{table_tau2_prior}
\title{Predictive distributions for the between-study variance in a future
meta-analysis on odds ratio or standardised mean difference}
\usage{
table_tau2_prior(measure, area)
}
\arguments{
\item{measure}{Character string indicating the effect measure with possible
values \code{"OR"} for odds ratio and \code{"SMD"} for standardised mean
difference.}

\item{area}{Character string indicating the medical area relating to the
predictive distributions for standardised mean difference with possible
values \code{"cancer"} for medical areas of cancer, \code{"respiratory"}
for medical areas of respiratory diseases, and \code{"other"} for medical
areas other than cancer or respiratory diseases. The argument is not
relevant for odds ratio.}
}
\value{
A cross-sectional table as a heatmap showing the hyperparameters
(mean and standard deviation) of the corresponding predictive distribution
for all combinations between the outcome types and treatment-comparison types
and according to the selected medical area (only relevant with standardised
mean difference) as defined by Turner et al. (2015) and Rhodes et al. (2015).
The tiles are coloured with different shades according to the corresponding
median value: the larger the median, the darker the colour.
}
\description{
A table with the hyperparameters of the predictive distributions for the
between-study variance developed by Turner et al. (2015) and Rhodes et al.
(2015): log-normal distribution and t-distribution (with 5 degrees of
freedom) when the outcome data are analysed in the odds ratio or
standardised mean difference scale, respectively.
}
\details{
This table aids in selecting the hyperparameters for the function
\code{\link{heterogeneity_param_prior}} when considering an informative prior
distribution for the between-study variance parameter based on the two
publications mentioned above (relevant for the function
\code{\link{run_model}} to conduct random-effects network meta-analysis).
}
\references{
Rhodes KM, Turner RM, Higgins JP. Predictive distributions were developed
for the extent of heterogeneity in meta-analyses of continuous outcome data.
\emph{J Clin Epidemiol} 2015;\bold{68}(1):52--60.
doi: 10.1016/j.jclinepi.2014.08.012

Turner RM, Jackson D, Wei Y, Thompson SG, Higgins JP. Predictive
distributions for between-study heterogeneity and simple methods for their
application in Bayesian meta-analysis.
\emph{Stat Med} 2015;\bold{34}(6):984--98. doi: 10.1002/sim.6381
}
\seealso{
\code{\link{heterogeneity_param_prior}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
