% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyserial.R
\name{polyserial}
\alias{polyserial}
\title{Robust estimation of polyserial correlation}
\usage{
polyserial(
  x,
  y,
  alpha = 0.5,
  num_y = max(y),
  constrained = "ifneeded",
  method = NULL,
  variance = TRUE,
  weights = TRUE,
  init = polyserial_initialize_param(x = x, num_y = num_y, robust = TRUE),
  maxcor = 0.999,
  tol_thresholds = 0.01,
  tol_sigma2 = 0.01
)
}
\arguments{
\item{x}{Vector of numeric values.}

\item{y}{Vector of integer-valued ordinal values.}

\item{alpha}{Tuning constant that governs robustness-efficiency tradeoff; must be in \code{[0, Inf]}. Defaults to 0.5.}

\item{num_y}{Number of response categories in y; defaults to max(y)}

\item{constrained}{Shall parameter restructions be enforced by linear constraints? This can be a logical (\code{TRUE} or \code{FALSE}), or \code{"ifneeded"} to first try unconstrained optimization and in case of an error perform constrained optimization. Default is \code{"ifneeded"}.}

\item{method}{Numerical optimization method, see \code{\link[stats]{optim}()} and \code{\link[stats]{constrOptim}()}. Default is to use \code{"BFGS"} in case of unconstrained optimization and \code{"Nelder-Mead"} in case of constrained optimization.}

\item{variance}{Shall an estimated asymptotic covariance matrix be returned? Default is \code{TRUE}.}

\item{weights}{Shall weights be returned? Default is \code{TRUE}.}

\item{init}{Initialization of numerical optimization. Default is neutral.}

\item{maxcor}{Maximum absolute correlation (to ensure numerical stability). Default is 0.999.}

\item{tol_thresholds}{Minimum distance between consecutive thresholds (to enforce strict monotonicity); only relevant in case of constrained optimization. Default is 0.01.}

\item{tol_sigma2}{Minimum value of sigma2 parameter (population variance of X); only relevant in case of constrained optimization. Default is 0.01.}
}
\value{
An object of class \code{"polyserial"}, which is a list with the following components. 
\describe{
  \item{\code{thetahat}}{A vector of estimates for the polyserial correlation coefficient (\code{rho}), population mean of X (\code{mu}), population variance of Y (\code{sigma2}), as well as thresholds for \code{y} (named \code{tau1,tau2,...,tau_{r-1}}).}
  \item{\code{stderr}}{A vector of standard errors for each estimate in \code{thetahat}.}
  \item{\code{vcov}}{Estimated asymptotic covariance matrix of \code{thetahat}. The matrix \eqn{\Sigma} in the paper (asymptotic covariance matrix of \eqn{\sqrt{N} \hat{\theta}}) can be obtained via \code{vcov * N}, where \code{N} is the sample size.}
  \item{\code{pointpolyserial}}{Estimated polyserial correlation coefficient, calculated with provided scoring of Y}
  \item{\code{weights}}{List of rescaled and raw outlyingness weights for each observation as well as maximum possible raw weight that was used for rescaling (\code{sup}).}
  \item{\code{objective}}{Value of minimized loss function.}
  \item{\code{optim}}{Object of class \code{optim}.}
  \item{\code{inputs}}{List of provided inputs.}
}
}
\description{
Implements the robust estimator of  Welz (2025, \doi{10.48550/arXiv.2510.15632})  for the polyserial correlation model.
}
\examples{
## example data
set.seed(123)
x <- rnorm(n = 100)
y <- sample(c(1,2), size = 100, replace = TRUE)

polyserial(x,y)

}
