% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationEstimators.R
\name{hodges_lehmann}
\alias{hodges_lehmann}
\title{One-sample Hodges-Lehmann estimator}
\usage{
hodges_lehmann(x, na.rm = FALSE)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values.}

\item{na.rm}{a logical value indicating whether NA values in \code{x} and
\code{y} should be stripped before the computation proceeds. The
default is \code{na.rm = FALSE}.}
}
\value{
The one-sample Hodges-Lehmann estimator.
}
\description{
\code{hodges_lehmann} calculates the one-sample Hodges-Lehmann estimator
of a sample.
}
\details{
The one-sample Hodges-Lehmann estimator for a sample of size \code{n}
         is defined as

\deqn{med(\frac{X_i + X_j}{2},  1 \le i < j \le m).}
}
\examples{
# Generate random sample
set.seed(108)
x <- rnorm(10)

# Compute one-sample Hodges-Lehmann estimator
hodges_lehmann(x)

}
\references{
\insertRef{HodLeh63esti}{robnptests}
}
