% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unweighted_estimators.R
\name{unweighted_plm}
\alias{unweighted_plm}
\title{Unweighted (baseline) estimator for the partially linear model}
\usage{
unweighted_plm(
  y_formula,
  y_learner,
  y_pars = list(),
  x_formula,
  x_learner,
  x_pars = list(),
  data,
  K = 5,
  S = 1
)
}
\arguments{
\item{y_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[Y|Z]}.}

\item{y_learner}{a string specifying the regression method to fit the regression of \eqn{Y} on \eqn{Z} as given by \code{y_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{y_pars}{a list containing hyperparameters for the \code{y_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{x_formula}{a two-sided formula object describing the regression model for \eqn{\mathbb{E}[X|Z]}.}

\item{x_learner}{a string specifying the regression method to fit the regression of \eqn{X} on \eqn{Z} as given by \code{x_formula} (e.g. \code{randomforest, xgboost, neuralnet, gam}).}

\item{x_pars}{a list containing hyperparameters for the \code{y_learner} chosen. Default is an empty list, which performs hyperparameter tuning.}

\item{data}{a data frame containing the variables for the partially linear model.}

\item{K}{the number of folds used for \eqn{K}-fold cross-fitting. Default is 5.}

\item{S}{the number of repeats to mitigate the randomness in the estimator on the sample splits used for \eqn{K}-fold cross-fitting. Default is 5.}
}
\value{
A list containing:
  \describe{
    \item{\code{theta}}{The estimator of \eqn{\theta_0}.}
    \item{\code{stderror}}{Huber robust estimate of the standard error of the \eqn{\theta_0}-estimator.}
    \item{\code{coefficients}}{Table of \eqn{\theta_0} coefficient estimator, standard error, z-value and p-value.}
  }
}
\description{
Estimates the parameter of interest \eqn{\theta_0} in the partially linear regression model
\deqn{\mathbb{E}[Y|X,Z] = X\theta_0 + f_0(Z),} as in \code{roseRF_plm} but without
any weights i.e. \eqn{J=1}, \eqn{M_1(X)=X} and \eqn{w_1\equiv 1}.
}
