% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert_tag}
\alias{convert_tag}
\alias{convert_tag.default}
\alias{convert_tag.return}
\alias{convert_tag.param}
\title{Convert a \code{roxygen2} tag to \code{roxytypes} equivalent}
\usage{
convert_tag(tag, format, ...)

\method{convert_tag}{default}(tag, format, ...)

\method{convert_tag}{return}(tag, format, ...)

\method{convert_tag}{param}(tag, format, ...)
}
\arguments{
\item{tag}{(\code{\link[roxygen2:roxy_tag]{roxygen2::roxy_tag()}}) A \code{roxygen2} tag to convert.}

\item{format}{(\code{character[1]}) A regular expression, optionally containing named capture groups for \code{type}
and \code{description}, which will be used for restructuring the tag as a
\code{roxytypes}-equivalent tag.}

\item{...}{Additional arguments unused.}
}
\value{
(``NULL\code{ or [tag_edit()]}) If the tag can be converted, a \code{\link[=tag_edit]{tag_edit()}} is returned, otherwise `NULL`.
}
\description{
Convert a \code{roxygen2} tag to \code{roxytypes} equivalent
}
\section{Methods (by class)}{
\itemize{
\item \code{convert_tag(default)}: Default handler for tags that can not be converted.

\item \code{convert_tag(return)}: Convert \verb{@return} tags, parsing type and description from existing
description.

\item \code{convert_tag(param)}: Convert \verb{@param} tags, parsing type and description from existing
description.

}}
\seealso{
Other convert: 
\code{\link{build_convert_edits}()},
\code{\link{convert_match_format}()},
\code{\link{make_convert_edits}()},
\code{\link{tag_edit}()}
}
\concept{convert}
\keyword{internal}
