% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LMS.R, R/Opal.R
\name{getLMSResources}
\alias{getLMSResources}
\alias{getLMSResources,missing-method}
\alias{getLMSResources,Opal-method}
\title{Get records of all current user's resources on LMS}
\usage{
getLMSResources(object, ...)

\S4method{getLMSResources}{missing}(object)

\S4method{getLMSResources}{Opal}(object)
}
\arguments{
\item{object}{An S4 object of class \link{Opal} that represents a connection to the LMS.}

\item{...}{Additional arguments to be passed to the method, if applicable.}
}
\value{
A dataframe with attributes of user's resources.
}
\description{
This method retrieves data about all resources associated with the current user on the Learning Management System (LMS).
If no LMS connection object is provided, it attempts to guess the connection using default settings (e.g., environment variables).
If the connection cannot be established, an error is thrown.
}
