% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pips_from_vector.R
\name{pips_from_vector}
\alias{pips_from_vector}
\title{Inclusion probabilities proportional-to-size}
\usage{
pips_from_vector(values, sample_size)
}
\arguments{
\item{values}{A vector of positive numbers}

\item{sample_size}{The wanted sample size}
}
\value{
A vector of inclusion probabilities proportional-to-size.
}
\description{
Computes the first-order inclusion probabilities from a vector of positive numbers,
for an inclusion probabilities proportional-to-size design.
}
\examples{
set.seed(12345);
N = 1000;
n = 100;
x = matrix(runif(N * 2), ncol = 2);
prob = pips_from_vector(x[, 1], n);
s = lpm_2(prob, x);
plot(x[, 1], x[, 2], pch = ifelse(sample_to_indicator(s, N), 19, 1));

}
