% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_dataspace.R, R/api_lpdaac.R, R/api_usgs.R,
%   R/extent_crs.R, R/records.R, R/rtoi.R, R/variables.R
\name{print,api_dataspace-method}
\alias{print,api_dataspace-method}
\alias{print,api}
\alias{print,api_lpdaac-method}
\alias{print,api_usgs-method}
\alias{print,extent_crs-method}
\alias{print,extent_crs}
\alias{print,records-method}
\alias{print,records}
\alias{print,rtoi-method}
\alias{print,variables-method}
\title{Prints the values}
\usage{
\S4method{print}{api_dataspace}(x)

\S4method{print}{api_lpdaac}(x)

\S4method{print}{api_usgs}(x)

\S4method{print}{extent_crs}(x)

\S4method{print}{records}(x)

\S4method{print}{rtoi}(x)

\S4method{print}{variables}(x, ...)
}
\arguments{
\item{x}{an object to be printed..}

\item{...}{additional arguments.}
}
\value{
prints rtoi metadata
}
\description{
prints an object and returns it invisibly (via invisible(x)).
}
\examples{
\dontrun{
library(rsat)

# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

print(navarre)

# get records
rcrds <- records(navarre)

print(rcrds)
}
}
