% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_JRS.R
\name{raw_JRS}
\alias{raw_JRS}
\title{Convert z-scores back to raw spirometric values using JRS (2014) equations}
\usage{
raw_JRS(
  age,
  height,
  gender = 1,
  FEV1 = NULL,
  FVC = NULL,
  VC = NULL,
  FEV1FVC = NULL
)
}
\arguments{
\item{age}{Age in years}

\item{height}{Height in meters}

\item{gender}{Gender (1 = male, 2 = female) or a factor with two levels (first = male). Default is 1.}

\item{FEV1}{Forced Expiratory Volume in 1 second (z-score)}

\item{FVC}{Forced Vital Capacity (z-score)}

\item{VC}{Vital Capacity (z-score)}

\item{FEV1FVC}{FEV1 / FVC (as z-score)}
}
\value{
If only one spirometry z-score argument is supplied, the function
returns a numeric vector. If more are supplied, the function returns 
a data.frame with the same number of columns.
}
\description{
This function takes z-scores based on the JRS (Japanese Respiratory Society 2014) equations, 
plus demographic data (age, height and gender), and converts them back
into absolute spirometry measurements (FEV1, FVC, VC, or FEV1FVC) in lt.
}
\details{
At least one of the spirometric z-score arguments must be set (i.e. be
non-\code{NULL}). Arguments \code{age}, \code{height} and \code{gender} 
must be vectors of length equal to the length of the
z-score vector(s), or of length one, in which case their value is recycled.
If any input vector is not of equal length, the function stops with an error.
}
\examples{
# Random data, 4 patients, one z-score parameter supplied (FEV1)
raw_JRS(age=seq(25,40,5), height=c(1.8, 1.9, 1.75, 1.85),
      gender=c(2,1,2,1), FEV1=c(-1.2, -1.9, 0, 0.5))

}
