% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rt_user_edit.R
\name{rt_user_edit}
\alias{rt_user_edit}
\title{Edit a user}
\usage{
rt_user_edit(
  user_id,
  password = NULL,
  name = NULL,
  email_address = NULL,
  real_name = NULL,
  organization = NULL,
  privileged = NULL,
  disabled = NULL,
  ...
)
}
\arguments{
\item{user_id}{(numeric) The ID of the User to edit}

\item{password}{(character) The password}

\item{name}{(character) Optional. User name}

\item{email_address}{(character) Optional. User email}

\item{real_name}{(character) Optional. User real name}

\item{organization}{(character) Optional. User organization}

\item{privileged}{(numeric) Optional. User privilege status}

\item{disabled}{(numeric) Optional. User disabled status}

\item{...}{Other arguments passed to \code{\link{rt_POST}}}
}
\value{
The ID of the edited user
}
\description{
Edit a user's information.
}
\examples{
\dontrun{
# First, create a user
user_id <- rt_user_create("Example", "password", "me@example.com")

# Then we can edit it
rt_user_edit(user_id, real_name = "Example User")
}
}
