% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtmsBrukerMCFReader.R
\name{newBrukerMCFReader}
\alias{newBrukerMCFReader}
\title{Open a Bruker multi-acquisition MCF directory}
\usage{
newBrukerMCFReader(mcfdir)
}
\arguments{
\item{mcfdir}{A directory (usually with the extension ".d") containing data
from a Bruker multi-acquisition run. This directory will contain a files with
extenssion ".mcf" and matching index files with extension ".mcf_idx" (see
Details).}
}
\value{
A reader object of class \code{rtmsBrukerMCFReader} with an open
connection to the main ".mcf" data file.
}
\description{
Creates an RTMS reader object (of class \code{rtmsBrukerMCFReader}) which can
extract data from a Bruker multi-acquisition directory (extension ".d")
}
\details{
Currently, RTMS can create reader objects for two binary Bruker data formats,
BAF (presumably standing for "Bruker acquisition format") holding data from
a single spectrum acquisition, and MCF (probably "multi-acquisition container
format") containing data from multiple spectra acquired in a single run.
Both formats hold data in a directory marked with the extension ".d". The
multi-acquisition MCF format directory contains four essential data files:
the main raw data file ending in "_1" with extension ".mcf", a matching
index file with extension ".mcf_idx", and a calibration data file ending in
"_2" with  extension ".mcf", and the matching calibration index file with
extension ".mcf_idx". This function preprocesses the main index file and
calibration files so that raw data can be extracted quickly on demand from
the main ".mcf" file.

An important note: when a MCF multi-acquisition reader is created, it creates
an open connection to the raw data file, which allows for quicker processing
of many spectra in a single file.  This connection will remain open until
the reader is closed with the \code{close} function.
}
