#' All self-determination movements' and their factions' use of violent and
#' non-violent tactics
#'
#' A dataset containing details of all self-determination movements' and their
#' factions' use of violent and non-violent tactics from 1960 to 2005.
#'
#' @format A data frame with 12017 rows and 19 variables:
#' \describe{
#'   \item{kgcid}{group's unique ID}
#'   \item{group_name}{group's name}
#'   \item{facid}{organisation's unique ID}
#'   \item{fac_name}{organisation's name}
#'   \item{year}{calendar year}
#'   \item{violence_state}{Any violence committed against government or people working for government (military and police forces included)}
#'   \item{fatal_violence_state}{Any violence committed against government or people working for government (military and police forces included) wherein at least one person died (regardless of who that person is)}
#'   \item{violence_org}{Any violence commited against another organization operating within the same group in the dataset}
#'   \item{fatal_violence_org}{Any violence commited against another organization operating within the same group in the dataset wherein at least one person died (regardless of who that person is)}
#'   \item{violence_ingroup}{Any violence committed against civilians of the group’s population}
#'   \item{fatal_violence_ingroup}{Any violence committed against civilians in the group’s population wherein at least one person died (regardless of who that person is)}
#'   \item{violence_outgroup}{Any violence against civilians outside of the group’s population}
#'   \item{fatal_violence_outgroup}{Any violence against civilians outside of the group’s population wherein at least one person died (regardless of who that person is)}
#'   \item{economic_noncoop}{Reports of strikes, tax refusal or consumer boycotts that are either organized by the organization, or people from the organization have participated}
#'   \item{protest_demonstration}{Rally, protest, or demonstration either organized by the organization, or people from the organization have participated}
#'   \item{nvintervention}{Sit-ins, occupations, or blockades reported; either organized by the organization, or people from the organization have participated}
#'   \item{social_noncoop}{Hunger strike, self-immolation or other self-harm reported; either organized by the organization, or people from the organization have participated}
#'   \item{institutional}{Organization registers as political party, participates in an election, participates in a national or local electoral campaign}
#'   \item{political_nocoop}{Organization boycotts an election or withdrawals from political office or coalition in the government}
#' }
#' @source \url{http://www.kathleengallaghercunningham.com/data-projects.html}
"orgs"

#' All self-determination movements
#'
#' A dataset containing details of all self-determination movements and the
#' countries they challenged from 1960 to 2005.
#'
#' @format A data frame with 5549 rows and 5 variables:
#' \describe{
#'   \item{kgcid}{group's unique ID}
#'   \item{group_name}{group's name}
#'   \item{year}{calendar year}
#'   \item{country}{country the group is challenging}
#'   \item{country_iso3c}{the ISO3C for the country the group is challenging}
#' }
#' @source \url{http://www.kathleengallaghercunningham.com/data-projects.html}
"groups"

