% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.eblupres}
\alias{summary.eblupres}
\title{Summarizing EBLUP Model Fits.}
\usage{
\method{summary}{eblupres}(object, ...)
}
\arguments{
\item{object}{EBLUP model.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
The function returns a data frame that contains the following columns: \cr
   * \code{y} variable response \cr
   * \code{eblup} estimated results for each area \cr
   * \code{random_effect} random effect for each area \cr
   * \code{vardir} variance sampling from the direct estimator for each area \cr
   * \code{mse} Mean Square Error \cr
   * \code{cluster} cluster information for each area \cr
   * \code{rse} Relative Standart Error (%) \cr
}
\description{
`summary` method for class "eblupres".
}
\examples{
library(saens)

model1 <- eblupfh_cluster(y ~ x1 + x2 + x3, data = mys, vardir = "var", cluster = "clust")
summary(model1)

}
