% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.safeframe.R
\name{print.safeframe}
\alias{print.safeframe}
\title{Printing method for safeframe objects}
\usage{
\method{print}{safeframe}(x, ...)
}
\arguments{
\item{x}{a \code{safeframe} object}

\item{...}{further arguments to be passed to 'print'}
}
\value{
Invisibly returns the object.
}
\description{
This function prints safeframe objects.
}
\examples{
## create safeframe
x <- make_safeframe(cars,
  mph = "speed",
  distance = "dist"
)

## print object - using only the first few entries
head(x)

# version with a tibble
if (require(tibble) && require(magrittr)) {
  cars \%>\%
    tibble() \%>\%
    make_safeframe(
      mph = "speed",
      distance = "dist"
    )
}
}
