% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tTest.R
\name{plot.safeTSim}
\alias{plot.safeTSim}
\title{Plots a 'safeTSim' Object}
\usage{
\method{plot}{safeTSim}(x, y = NULL, showOnlyNRejected = FALSE, nBin = 25, ...)
}
\arguments{
\item{x}{a 'safeDesign' object acquired from \code{\link{designSafeT}()}.}

\item{y}{\code{NULL}.}

\item{showOnlyNRejected}{logical, when \code{TRUE} discards the cases that did not reject.}

\item{nBin}{numeric > 0, the minimum number of bins in the histogram.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
a histogram object, and called for its side-effect to plot the histogram.
}
\description{
Plots a 'safeTSim' Object
}
\examples{
# Design safe test
alpha <- 0.05
beta <- 0.20
designObj <- designSafeT(1, alpha=alpha, beta=beta)

# Design frequentist test
freqObj <- designFreqT(1, alpha=alpha, beta=beta)

# Simulate under the alternative with deltaTrue=deltaMin
simResults <- simulate(designObj, nSim=100)

plot(simResults)

plot(simResults, showOnlyNRejected=TRUE)
}
