% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logRankTest.R
\name{sampleLogrankStoppingTimes}
\alias{sampleLogrankStoppingTimes}
\title{Simulate stopping times for the exact safe logrank test}
\usage{
sampleLogrankStoppingTimes(
  hazardRatio,
  alpha = 0.05,
  alternative = c("twoSided", "less", "greater"),
  m0 = 50000L,
  m1 = 50000L,
  nSim = 1000L,
  groupSizePerTimeFunction = returnOne,
  parameter = NULL,
  nMax = Inf,
  pb = TRUE
)
}
\arguments{
\item{hazardRatio}{numeric that defines the data generating hazard ratio with which data are sampled.}

\item{alpha}{numeric in (0, 1) that specifies the tolerable type I error control --independent on n-- that the
designed test has to adhere to. Note that it also defines the rejection rule e10 > 1/alpha.}

\item{alternative}{a character string specifying the alternative hypothesis, which must be one of
"twoSided" (default),"greater" or "less". The alternative is pitted against the null hypothesis of equality
of the survival distributions. More specifically, let lambda1 be the hazard rate of group 1 (i.e., placebo), and
lambda2 the hazard ratio of group 2 (i.e., treatment), then the null hypothesis states that the hazard ratio
theta = lambda2/lambda1 = 1. If alternative = "less", the null hypothesis is compared to theta < 1, thus,
lambda2 < lambda1, that is, the hazard of group 2 (i.e., treatment) is less than that of group 1 (i.e., placebo),
hence, the treatment is beneficial. If alternative = "greater", then the null hypothesis is compared to theta > 1,
thus, lambda2 > lambda1, hence, harm.}

\item{m0}{Number of subjects in the control group 0/1 at the beginning of the trial, i.e., nPlan[1].}

\item{m1}{Number of subjects in the treatment group 1/2 at the beginning of the trial, i.e., nPlan[2].}

\item{nSim}{integer > 0, the number of simulations needed to compute power or the number of events for the exact
safe logrank test under continuous monitoring}

\item{groupSizePerTimeFunction}{A function without parameters and integer output. This function provides the number
of events at each time step. For instance, if \code{rpois(1, 7)} leads to a random number of events at each time
step.}

\item{parameter}{Numeric > 0, represents the safe tests defining thetaS. Default NULL so it's decided by the
algorithm, typically, this equals hrMin, which corresponds to the GROW choice.}

\item{nMax}{An integer. Once nEvents hits nMax the experiment terminates, if it didn't stop due to threshold
crossing crossing already. Default set to Inf.}

\item{pb}{logical, if \code{TRUE}, then show progress bar.}
}
\value{
a list with stoppingTimes and breakVector. Entries of breakVector are 0, 1. A 1 represents stopping
due to exceeding nMax, and 0 due to 1/alpha threshold crossing, or running out of participants, which implies
that the corresponding stopping time is Inf.
}
\description{
Simulate stopping times for the exact safe logrank test
}
\examples{
sampleLogrankStoppingTimes(0.7, nSim=10)
}
\author{
Muriel Felipe Perez-Ortiz and Alexander Ly
}
