% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estor.R
\name{estor}
\alias{estor}
\title{Sample size for estimation of Odds Ratio with specified precision}
\usage{
estor(p0, or, alp, prec, k)
}
\arguments{
\item{p0}{Probability of exposure among the controls}

\item{or}{Anticipated Odds Ratio (OR)}

\item{alp}{level of significance or probability of claiming the association exists when in fact there is no association}

\item{prec}{Precision desired on either side of OR}

\item{k}{the number of controls for each case}
}
\value{
a list object, the required minimum sample size along with description for reporting
}
\description{
Odds ratios are estimated in a case-control study design to assess the association of
outcome with past exposure. This function estimates the sample size needed to estimate the true odds
ratio with specified precision.
}
\examples{
estor(p0 = 0.35, or = 2, alp = 0.05, prec = 0.25, k = 1)
}
\references{
Lwanga, S. K., Lemeshow, S., & World Health Organization. (1991). Sample size determination in health studies: a practical manual. World Health Organization.
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
