% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testRR.R
\name{testRR}
\alias{testRR}
\title{Sample size for testing relative risk}
\usage{
testRR(RR, p0, alp, pwr, k = 1)
}
\arguments{
\item{RR}{anticipated relative risk}

\item{p0}{probability of outcome among the unexposed}

\item{alp}{level of significance or accepted level of probability of type I error}

\item{pwr}{desired level of power}

\item{k}{number of unexposed for each exposed}
}
\value{
a list object with minimum required  sample size along with description for reporting
}
\description{
When we try to associate multiple exposures to an outcome, we need to know the
relative risk (RR) of a particular exposure in the presence of other exposures
and test their importance in the model using a significance test based on RR.
This function computes sample size based on testing RR for a cohort study design.
}
\examples{
testRR(p0 = 0.2, RR = 1.5, alp = 0.05, pwr = 0.84, k = 1)
}
\author{
R. Amala, Scientist-C, ICMR-VCRC, Puducherry  & G. Kumarapandiyan, Asst. Prof., Madras Christian College, Chennai
}
