% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{poch}
\alias{poch}
\title{Compute the Pochhammer Symbol (Rising Factorials) With Increment}
\usage{
poch(x, y = NULL, n = 1, log = FALSE)
}
\arguments{
\item{x}{Non-negative numeric value}

\item{y}{Non-negative real value representing increment parameter for
Pochhammer function. If \code{NULL}, there is no increment (i.e.
\code{y=1}).}

\item{n}{Non-negative integer representing subscript in Pochhammer symbol}

\item{log}{Logical value indicating whether to return results on log scale}
}
\value{
A numeric value indicating the result of Pochhammer function.
}
\description{
Compute the Pochhammer Symbol (Rising Factorials) With Increment
}
\examples{
# effect of increment parameter
poch(5, y = NULL, n = 3, log = FALSE)
poch(5, y = 1, n = 3, log = FALSE)
poch(5, y = 1:4, n = 3, log = FALSE)

# increment being NULL is equivalent to ratio of gamma functions
a <- 7
b <- 3
out1 <- poch(a, y = NULL, n = b, log = FALSE)
out2 <- gamma(a + b) / gamma(a)

}
