% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_upload_files.R
\name{item_publish_cloud}
\alias{item_publish_cloud}
\title{Publish file to public cloud S3 bucket}
\usage{
item_publish_cloud(sb_id, files, ...)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{files}{A string vector of paths to files to be uploaded}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}
}
\value{
web service response invisibly.
}
\description{
moves a cloud file from the S3 bucket only available via
ScienceBase authenticated services to a public S3 bucket.
}
\examples{
\dontrun{
res <- item_create(user_id(), "testing 123")
cat("foo bar", file = "foobar.txt")
item_upload_cloud(res$id, "foobar.txt")
item_publish_cloud(res$id, "foobar.txt") 
}

}
