% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_gsea.R
\name{run_hypergeometric_gsea}
\alias{run_hypergeometric_gsea}
\title{Compute enriched gene sets among significant genes in a cell type for
a factor using hypergeometric test}
\usage{
run_hypergeometric_gsea(
  container,
  factor_select,
  ctype,
  up_down,
  thresh = 0.05,
  min_gs_size = 15,
  max_gs_size = 500,
  db_use = "GO"
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factor_select}{numeric The factor of interest}

\item{ctype}{character The cell type of interest}

\item{up_down}{character Either "up" to compute enrichment among the significant
positive loading genes or "down" to compute enrichment among the significant
negative loading genes.}

\item{thresh}{numeric Pvalue significance threshold. Used as cutoff for calling
genes as significant to use for enrichment tests. (default=0.05)}

\item{min_gs_size}{numeric Minimum gene set size (default=15)}

\item{max_gs_size}{numeric Maximum gene set size (default=500)}

\item{db_use}{character The database of gene sets to use. Database
options include "GO", "Reactome", "KEGG", and "BioCarta". More than
one database can be used. (default="GO")}
}
\value{
A vector of adjusted p-values for enrichment of gene sets in the 
significant genes of a given cell type in a given factor.
}
\description{
Compute enriched gene sets among significant genes in a cell type for
a factor using hypergeometric test
}
