% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_scale_description_table.R
\name{make_scale_description_table}
\alias{make_scale_description_table}
\title{Create a Descriptive Statistics Table Row}
\usage{
make_scale_description_table(descr_object, scale_name)
}
\arguments{
\item{descr_object}{An object returned by \code{psych::describe()}.
Must contain: \code{n}, \code{mean}, \code{sd}, \code{median},
\code{min}, \code{max}, \code{skew}, \code{kurtosis}.}

\item{scale_name}{A single character string specifying the name of the scale.}
}
\value{
A single-row data frame with formatted descriptive statistics.
}
\description{
Formats a descriptive statistics object into a single-row data frame
}
\details{
This function is intended for reporting descriptive statistics of
total scores that has been calculated using psych::describe().
}
\examples{
{
  # Create 10 random PHQ-9 scores
  phq9_data <- as.data.frame(matrix(sample(0:3, 10 * 9, replace = TRUE), 10, 9))
  colnames(phq9_data) <- paste0("Q", 1:9)
  phq9_data$total <- rowSums(phq9_data)
  descr_total <- psych::describe(phq9_data$total)
  make_scale_description_table(descr_total, scale_name = "PHQ-9")
}
}
