% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline_estimation.R
\name{estimate_baselines}
\alias{estimate_baselines}
\title{Estimate baselines based on observed counts.}
\usage{
estimate_baselines(counts, population = NULL)
}
\arguments{
\item{counts}{A matrix of observed counts. Rows indicate time (ordered from 
most recent) and columns indicate locations.}

\item{population}{A matrix or vector of populations for each location 
(optional). If a matrix, should be of the same dimensions as 
\code{counts}. If a vector, should be of the same length as the number of
columns in \code{counts}.}
}
\value{
A matrix of baselines of the same dimensions as \code{counts}.
}
\description{
Estimate the baselines (expected values) for the supplied counts.
}
\keyword{internal}
