% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{cv.2.rast}
\alias{cv.2.rast}
\title{Class vector to raster}
\usage{
cv.2.rast(
  r,
  classVector,
  index = NULL,
  plot = FALSE,
  type = "classes",
  writeRaster = NULL,
  overWrite = FALSE
)
}
\arguments{
\item{r}{raster object.}

\item{classVector}{numeric vector, the values to be assigned to the cell
numbers indicated by \code{index}.}

\item{index}{numeric vector, the cell numbers of the argument \code{r} to
which assign the values of the argument \code{classVector}. If \code{NULL},
the column \code{Cell} of the attribute table \code{attTbl(r)} is used (see
\code{\link{attTbl}}).}

\item{plot}{logic, plot the raster.}

\item{type}{character, type of map/legend. One of "continuous", "classes", or
"interval".}

\item{writeRaster}{filename, if a raster name is provided save the raster to
a file.}

\item{overWrite}{logic, if the raster names already exist, the existing file
is overwritten.}
}
\value{
A class vector or a generic vector transformed into a raster.
}
\description{
Transform a class vector or a generic vector into a raster.
}
\details{
The arguments \code{index} and \code{vector} need to have the same
length. The function assign the values of \code{vector} at the positions of
\code{index} to an empty raster having the same spatial properties of the
raster \code{r}.
}
\examples{
library(scapesClassification)
library(terra)

# LOAD THE DUMMY RASTER
r <- list.files(system.file("extdata", package = "scapesClassification"),
                pattern = "dummy_raster\\\\.tif", full.names = TRUE)
r <- terra::rast(r)

# COMPUTE THE ATTRIBUTE TABLE
at <- attTbl(r, "dummy_var")

# COMPUTE THE LIST OF NEIGBORHOODS
nbs <- ngbList(r)

# Compute an example class vector
cv <- cond.4.all(attTbl = at, cond = "dummy_var > 1", class = 1)

# Class vector to raster
cv.2.rast(r, cv, plot = TRUE)
text(r) # add raster values
}
