% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_dist.R
\name{scf_plot_dist}
\alias{scf_plot_dist}
\title{Plot a Univariate Distribution of an SCF Variable}
\usage{
scf_plot_dist(
  design,
  variable,
  bins = 30,
  title = NULL,
  xlab = NULL,
  ylab = "Percent",
  angle = 30,
  fill = "#0072B2",
  labels = NULL
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}.}

\item{variable}{A one-sided formula specifying the variable to plot.}

\item{bins}{Number of bins for continuous variables. Default is 30.}

\item{title}{Optional plot title.}

\item{xlab}{Optional x-axis label.}

\item{ylab}{Optional y-axis label. Default is "Percent".}

\item{angle}{Angle for x-axis tick labels. Default is 30.}

\item{fill}{Fill color for bars. Default is \code{"#0072B2"}.}

\item{labels}{Optional named vector of custom axis labels (for discrete variables only).}
}
\value{
A \code{ggplot2} object.
}
\description{
This function provides a unified plotting interface for visualizing the
distribution of a single variable from multiply-imputed SCF data. Discrete
variables produce bar charts of pooled proportions; continuous variables
produce binned histograms.  Use this function to visualize the univariate
distribution of an SCF variable.
}
\section{Implementation}{

For discrete variables (factor or numeric with <= 25 unique values), the
function uses \code{\link[=scf_freq]{scf_freq()}} to calculate category proportions and produces a
bar chart.  For continuous variables, it bins values across implicates and
estimates Rubin-pooled frequencies for each bin.

Users may supply a named vector of custom axis labels using the \code{labels} argument.
}

\examples{
# Mock workflow for CRAN (demo only — not real SCF data)
td <- tempfile("plot_dist_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

scf_plot_dist(scf2022, ~own)
scf_plot_dist(scf2022, ~age, bins = 10)

unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_theme]{scf_theme()}}
}
