% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-grim-sequence.R
\name{seq_test_ranking}
\alias{seq_test_ranking}
\title{Rank sequence test results}
\usage{
seq_test_ranking(x, explain = TRUE)
}
\arguments{
\item{x}{Data frame.}

\item{explain}{If \code{TRUE} (the default), results come with an explanation.}
}
\value{
A tibble (data frame). The function will also print an explanation of
the results. See examples.
}
\description{
Run this function after generating a sequence with
\code{seq_endpoint_df()} or \code{seq_distance_df()} and testing it with one of
scrutiny's mapping functions, such as \code{grim_map()}. It will rank the test's
consistent and inconsistent results by their positions in the sequence.
}
\details{
The function checks the provenance of the test results and throws a
warning if it's not correct.
}
\examples{
seq_distance_df(.from = "0.00", n = 50) \%>\%
  grim_map() \%>\%
  seq_test_ranking()
}
