% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_model_pars}
\alias{plot_model_pars}
\title{Plot estimated and fitted model parameters}
\usage{
plot_model_pars(
  vst_out,
  xaxis = "gmean",
  show_theta = FALSE,
  show_var = FALSE,
  verbosity = 2
)
}
\arguments{
\item{vst_out}{The output of a vst run}

\item{xaxis}{Variable to plot on X axis; default is "gmean"}

\item{show_theta}{Whether to show the theta parameter; default is FALSE (only the overdispersion factor is shown)}

\item{show_var}{Whether to show the average model variance; default is FALSE}

\item{verbosity}{An integer specifying the verbosity level: 0 (silent, no messages), 1 (show messages only), or 2 (show messages and progress bars); default is 2}
}
\value{
A ggplot object
}
\description{
Plot estimated and fitted model parameters
}
\examples{
\donttest{
vst_out <- vst(pbmc, return_gene_attr = TRUE)
plot_model_pars(vst_out)
}

}
