% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_xmile.R
\name{model_units}
\alias{model_units}
\title{Create, modify or remove custom units}
\usage{
model_units(sfm, name, eqn = "1", doc = "", erase = FALSE, change_name = NULL)
}
\arguments{
\item{sfm}{Stock-and-flow model, object of class \code{\link[=xmile]{sdbuildR_xmile}}.}

\item{name}{Name of unit. A character vector.}

\item{eqn}{Definition of unit. String or vector of unit definitions. Defaults to "1" to indicate a base unit not defined in terms of other units.}

\item{doc}{Documentation of unit.}

\item{erase}{If TRUE, remove model unit from the model. Defaults to FALSE.}

\item{change_name}{New name for model unit. Defaults to NULL to indicate no change.}
}
\value{
A stock-and-flow model object of class \code{\link[=xmile]{sdbuildR_xmile}}
}
\description{
A large library of units already exists, but you may want to define your own custom units. Use \code{\link[=model_units]{model_units()}} to add, change, or erase custom units from a stock-and-flow model. Custom units may be new base units, or may be defined in terms of other (custom) units. See \code{\link[=u]{u()}} for more information on the rules of specifying units. Note that units are only supported in Julia, not in R.
}
\examples{
\dontshow{if (julia_status()$status == "ready") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Units are only supported with Julia
sfm <- xmile("Crielaard2022")
sfm <- model_units(sfm, "BMI", eqn = "kg/m^2", doc = "Body Mass Index")

# You may also use words rather than symbols for the unit definition.
# The following modifies the unit BMI:
sfm <- model_units(sfm, "BMI", eqn = "kilogram/meters^2")

# Remove unit:
sfm <- model_units(sfm, "BMI", erase = TRUE)

# Unit names may be changed to be syntactically valid and avoid overlap:
sfm <- model_units(xmile(), "C0^2")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=unit_prefixes]{unit_prefixes()}}
}
\concept{units}
