% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cm_cmlat_prior_ocular.R
\name{check_cm_cmlat_prior_ocular}
\alias{check_cm_cmlat_prior_ocular}
\title{Check if ocular concomitant medication has laterality missing for specific
"PRIOR OCULAR THERAPIES AND TREATMENTS" (or similar names) CRF page.}
\usage{
check_cm_cmlat_prior_ocular(CM, preproc = identity, ...)
}
\arguments{
\item{CM}{Concomitant Medications Dataset for Ophtha Study with variables USUBJID, CMCAT, CMLAT, CMTRT, CMSPID
(if Present), CMSTDTC (if Present), CMLOC (if Present), CMINDC (if Present), CMDOSFRM (if Present)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the test failed
}
\description{
This check assesses ocular CMCAT records and flags records with
missing/inconsistent laterality
}
\examples{

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = "PRIOR OCULAR THERAPIES AND TREATMENTS",
   CMSTDTC = 1:5,
   CMLAT   = c("Left", "","Bilateral", "", ""),
   CMTRT   = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRAVITREAL", "opHTHALMIC"),
   CMSPID  = "FORMNAME-R:13/L:13XXXX",
   stringsAsFactors = FALSE)
check_cm_cmlat_prior_ocular(CM,preproc=roche_derive_rave_row)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = "Prior Ocular Therapies/Treatments",
   CMSTDTC = 1:5,
   CMLAT   = c("", "LEFT","Bilateral", "", "RIgHT"),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   #CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRAVITREAL", "opHTHALMIC"),
   stringsAsFactors = FALSE)
check_cm_cmlat_prior_ocular(CM)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = "CONCOMITANT MEDICATIONS",
   CMSTDTC = 1:5,
   CMLAT   = c("Left", "LEFT","Bilateral", "RIGHT", "RIgHT"),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRAVITREAL", "opHTHALMIC"),
   stringsAsFactors = FALSE)
check_cm_cmlat_prior_ocular(CM)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = "CONCOMITANT MEDICATIONS",
   CMSTDTC = 1:5,
   CMLAT   = c("Left", "LEFT","Bilateral", "RIGHT", "RIgHT"),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   #CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","INTRAVITREAL", "opHTHALMIC"),
   stringsAsFactors = FALSE)
check_cm_cmlat_prior_ocular(CM)

CM <- data.frame(
   USUBJID = 1:5,
   CMCAT = c(rep("Prior Ocular Therapies/Treatments",3), rep("Non-Ocular Therapies/Treatments",2)),
   CMSTDTC = 1:5,
   CMLAT   = c("", "LEFT","Bilateral", "", ""),
   CMTRT  = c("A", "B", "A", "B", "A"),
   CMDECOD = c("A", "B", "A", "B", "A"),
   #CMROUTE = c("","OPHTHALMIC","INTRAVITREAL","ORAL", "ORAL"),
   stringsAsFactors = FALSE)
check_cm_cmlat_prior_ocular(CM)



}
\seealso{
Other OPHTH: 
\code{\link{check_ae_aelat}()},
\code{\link{check_cm_cmlat}()},
\code{\link{check_oe_bcva_1m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_late_early_tot}()},
\code{\link{check_oe_bcva_4m_vs_1m_req}()},
\code{\link{check_oe_bcva_tot_mismatch}()},
\code{\link{check_oe_sc_lat_count_fingers}()},
\code{\link{check_pr_prlat}()},
\code{\link{check_sc_dm_eligcrit}()},
\code{\link{check_sc_dm_seyeselc}()}
}
\author{
Tim Barnett (HackR 2021 Team Eye) (copied from check_cm_cmlat)
}
\concept{OPHTH}
\keyword{OPHTH}
