% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_lb_missing_month.R
\name{check_lb_missing_month}
\alias{check_lb_missing_month}
\title{Check for lab dates with year and day known but month unknown}
\usage{
check_lb_missing_month(LB, preproc = identity, ...)
}
\arguments{
\item{LB}{Laboratory data SDTM dataset with variables USUBJID,LBTEST,LBDTC,VISIT}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
Check for missing month when lab specimen collection date (LBDTC)
has known year and day
}
\examples{

LB <- data.frame(
 USUBJID = 1:4,
 LBTEST = c("TEST1","TEST2","TEST3","TEST3"),
 LBDTC = c("2017-01-01","2017-02-01","2017---01", "2017----01"),
 VISIT = c("VISIT1","VISIT2","VISIT3","VISIT3"),
 stringsAsFactors=FALSE
)

check_lb_missing_month(LB)

LB$LBSPID= "FORMNAME-R:2/L:2XXXX"

check_lb_missing_month(LB,preproc=roche_derive_rave_row)

LB$LBDTC = NULL

check_lb_missing_month(LB)
}
\author{
Sara Bodach
}
