% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tr_trdtc_visit_ordinal_error.R
\name{check_tr_trdtc_visit_ordinal_error}
\alias{check_tr_trdtc_visit_ordinal_error}
\title{Check that all TR dates by INV are duplicated or earlier than
last visit's (possible date entry error)}
\usage{
check_tr_trdtc_visit_ordinal_error(TR)
}
\arguments{
\item{TR}{Tumor Response Measurement SDTM dataset with variables USUBJID,
VISITNUM, VISIT, TRDTC, TREVAL, TRSTAT}
}
\value{
boolean value if check failed or passed with 'msg' attribute if
the test failed
}
\description{
This check identifies TRDTC values when TREVAL == 'INVESTIGATOR'
are duplicated or earlier than last visit's. Unscheduled and 'NOT DONE' visits
are excluded.
}
\examples{

# no case
TR<- data.frame(USUBJID = 101:102,
                TRSEQ=rep(1:5,2),
                TRDTC=rep(c("2017-01-01T08:25", "2017-01-05T09:25",
                   "2017-01-15T10:25","2017-01-20T08:25","2017-01-25T08:25"), 2),
                VISITNUM=rep(1:5,2),
                VISIT=rep(c("Screening", "Cycle 1", "Cycle 2","Cycle 3","Follow-up"),2),
                TREVAL="INVESTIGATOR",
                TRSTAT="",
                stringsAsFactors=FALSE)
check_tr_trdtc_visit_ordinal_error(TR)

# Cases with earler datetime
TR$TRDTC[TR$USUBJID == 101 & TR$VISIT == "Cycle 3"] <- "2017-01-02T08:25"
TR$TRDTC[TR$USUBJID == 102 & TR$VISIT == "Cycle 1"] <- "2017-01-01T06:25"
check_tr_trdtc_visit_ordinal_error(TR)

}
\author{
James Zhang
}
