% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_tu_tuloc_missing.R
\name{check_tu_tuloc_missing}
\alias{check_tu_tuloc_missing}
\title{Check for missing TULOC values}
\usage{
check_tu_tuloc_missing(TU, preproc = identity, ...)
}
\arguments{
\item{TU}{Tumor Identification SDTM dataset with variables USUBJID, TUDTC,
VISIT, TUORRES, TULOC, TUSPID (optional)}

\item{preproc}{An optional company specific preprocessing script}

\item{...}{Other arguments passed to methods}
}
\value{
boolean value if check failed or passed with 'msg' attribute if the
test failed
}
\description{
This check looks for target lesions with missing TULOC values and
returns a data frame. Only applies to assessments by investigator.
}
\examples{
TU <- data.frame(
USUBJID = 1:10,
TUDTC = 1:10,
VISIT = "C1D1",
TUORRES = "TARGET",
TULOC = "LIVER",
TUSPID = "FORMNAME-R:19/L:19XXXX",
stringsAsFactors=FALSE
)

check_tu_tuloc_missing(TU)

TU$TULOC[1] = "NA"
TU$TULOC[2] = ""
TU$TULOC[3] = NA

check_tu_tuloc_missing(TU,preproc=roche_derive_rave_row)

TU$TUSPID <- NULL
check_tu_tuloc_missing(TU)


}
\author{
Will Harris
}
