% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_votings_table.R
\name{get_votings_table}
\alias{get_votings_table}
\title{Importing votings table from a database}
\usage{
get_votings_table(dbname = 'sejmrp', user = 'reader',
  password = 'qux94874', host = 'services.mini.pw.edu.pl',
  sorted_by_id = TRUE, windows = .Platform$OS.type == 'windows')
}
\arguments{
\item{dbname}{name of database; default: 'sejmrp'}

\item{user}{name of user; default: 'reader'}

\item{password}{password of database; default: 'qux94874'}

\item{host}{name of host; default: 'services.mini.pw.edu.pl'}

\item{sorted_by_id}{information if table should be sorted by id; default: TRUE}

\item{windows}{information of used operation system;
default: .Platform$OS.type == 'windows'}
}
\value{
data frame
}
\description{
Function \code{get_votings_table} imports votings table from a database.
}
\details{
Function \code{get_votings_table} imports votings table from a database.
The result of this function is a data frame with votings' data. Because of
encoding issue on Windows operation system, you need to select if you use Windows.
}
\note{
Default parameters use privilages of 'reader'. It can only SELECT data from database.

All information is stored in PostgreSQL database.
}
\examples{
\dontrun{
votings <- get_votings_table()
dim(votings)
# [1] 6212 7
names(votings)
# [1] 'id_voting' 'nr_term_of_office' 'nr_meeting'   
# [4] 'date_meeting' 'nr_voting' 'topic_voting' 
# [7] 'link_results'}

}
\author{
Piotr Smuda
}

