% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{benchmark}
\alias{benchmark}
\title{Helper function to benchmark an instance}
\usage{
benchmark(
  omit,
  weights,
  data,
  sigma2,
  estimand = "ATT",
  weighting_method = "ebal",
  weight_max = Inf
)
}
\arguments{
\item{omit}{Variable to omit}

\item{weights}{Vector of estimated weights}

\item{data}{data.frame containing outcomes and covariate information}

\item{sigma2}{Variance of the outcome variable}

\item{estimand}{Specifies estimand; possible parameters include "ATT" or "PATE",}

\item{weighting_method}{Weighting method. Supports weighting methods from the package \code{WeightIt}.}

\item{weight_max}{Maximum weight to trim at. Default set to \code{Inf}}
}
\value{
Benchmarking results for a single covariate
}
\description{
Returns the benchmarking results for a single covariate (or a single group of covariates)
}
\keyword{internal}
