% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{possible.table}
\alias{possible.table}
\title{Generate All Possible Contingency Tables Exceeding or Not Exceeding a Threshold}
\usage{
possible.table(
  threshold,
  table,
  direction = c("greater than", "less than"),
  transform.fun
)
}
\arguments{
\item{threshold}{A numeric value representing the cutoff for the test statistic.}

\item{table}{A matrix or table object specifying the observed contingency table.
The function will preserve the row/column sums (margins) of this table when
generating possible tables.}

\item{direction}{A character string, either \code{"greater than"} or \code{"less than"},
indicating whether to return tables whose test statistic is \code{>= threshold}
or \code{<= threshold}. Defaults to \code{c("greater than", "less than")} but
you should pass in one value explicitly.}

\item{transform.fun}{A user-defined function of the form \code{f(tbl)}, which takes
a contingency table (as a matrix or table) and returns a numeric test statistic.}
}
\value{
A list of all contingency tables (each table is returned as a
\code{table} object) that meet the specified \code{threshold} criterion.
If no tables match or the dimension is not supported, \code{NULL} is returned.
}
\description{
Given an observed contingency table (with fixed margins) and a user-defined
function that computes a test statistic, this function enumerates all
valid contingency tables that meet a particular criterion (i.e., those
with \code{T(table) >= threshold} or \code{T(table) <= threshold}).
}
\details{
The function systematically iterates over all valid ways to fill a contingency
table of dimension \code{I x J} such that row and column sums match the original
\code{table}'s margins. Only those tables that satisfy \code{transform.fun(tbl) >= threshold}
(for \code{direction = "greater than"}) or \code{transform.fun(tbl) <= threshold}
(for \code{direction = "less than"}) are returned.

Currently, this function supports certain table dimensions (\code{I} up to 5
when \code{J=2}, etc.). If the dimension is not supported, it returns
\code{NULL} with a warning.
}
\examples{
# Suppose we have a 3x3 table:
obs_table <- matrix(c(5, 3, 2, 6, 11, 7, 3, 0,3), ncol = 3, byrow = TRUE)
obs_table

# Define a simple test statistic function (e.g., sum of diagonal)
diag_sum <- function(tbl) sum(diag(tbl))

# Find all 3x3 tables with the same margins where the diagonal sum >= 19
result <- possible.table(threshold = 19, table = obs_table,
                        direction = "greater than", transform.fun = diag_sum)
result[[1]]         # Inspect the first matching table

}
