% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domain_history}
\alias{sst_sa_domain_history}
\title{Domain history}
\usage{
sst_sa_domain_history(
  domain,
  se,
  sort = NULL,
  filters = NULL,
  page = 1,
  size = 100,
  during_all_time = TRUE,
  return_method = "list",
  api_token = Sys.getenv("SERPSTAT_API_TOKEN")
)
}
\arguments{
\item{domain}{(required) Domain to get data for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{filters}{(optional) A list of filtering options. See Filtering for more
details.}

\item{page}{(optional) Response page number if there are many pages in response.}

\item{size}{(optional) Response page size.}

\item{during_all_time}{(optional) TRUE (default) for all the history,
FALSE for year-to-date data.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}

\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}. Default is Sys.getenv('SERPSTAT_API_TOKEN').}
}
\value{
Returns a number of metrics for each date for the domain.
}
\description{
Returns historical metrics for the domain with about two weeks between measurements.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://api-docs.serpstat.com/docs/serpstat-public-api/jtjb01xqgwv8p-get-domains-history}{here}.
}

\section{API credits consumption}{
 1 per date in the response.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\section{Filtering}{

  To filter the results you can use \code{filters} argument. It must be a
  list of named elements. The name of the element must match one of the
  filtering parameters. See API docs for more details. For example,
  \code{filters = list(queries_from = 0, queries_to = 10)} would narrow
  the results to include only the keywords that have a search volume
  between 0 and 10.
}

\examples{
\dontrun{
sst_sa_domain_history(
  domain        = 'serpstat.com',
  se            = 'g_us',
  sort          = list(date = 'desc'),
  filters       = list(traff_from = 20000),
  page          = 2,
  size          = 10,
  return_method = 'df'
)$data
}
}
