% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probstat.R
\name{probstat}
\alias{probstat}
\title{probstat}
\usage{
probstat(y, x, test = "Fisher", ri, nfolds, seed = 10101)
}
\arguments{
\item{y}{A binary outcome vector (logical or numeric coded as 0/1). Length
`n`.}

\item{x}{A data frame of predictors (typically the expanded data returned by
[pairmi()]). Must have `n` rows; columns are treated as candidate
predictors.}

\item{test}{Character string selecting the inferential method; one of
`c("fisher", "glmm")`. Defaults to `"fisher"` if missing.}

\item{ri}{Optional vector/factor giving the grouping variable for a random
intercept in the GLMM. Must be length `n`. Ignored if `test = "fisher"`.}

\item{nfolds}{Integer; number of folds used for cross-validation.}

\item{seed}{Integer seed for fold randomization.}
}
\value{
A data frame with one row per evaluated predictor (or pair) and the
  following columns:
\describe{
  \item{xprob}{Marginal probability of \eqn{X=1}.}
  \item{yprob}{Marginal probability of \eqn{Y=1}.}
  \item{cprob}{Conditional probability \eqn{P(Y=1 \mid X=1)}.}
  \item{cprobx}{Conditional probability \eqn{P(X=1 \mid Y=1)}.}
  \item{cprobi}{Inverse conditional probability \eqn{P(Y=1 \mid X=0)}.}
  \item{cpdif}{Difference \eqn{P(Y=1 \mid X=1) - P(Y=1)}.}
  \item{cpdifper}{Percent difference relative to \eqn{P(Y=1)}.}
  \item{xent}{Entropy of \eqn{X}.}
  \item{yent}{Entropy of \eqn{Y}.}
  \item{ce}{Conditional entropy of \eqn{Y \mid X}.}
  \item{cedif}{Difference between marginal and conditional entropy of \eqn{Y}.}
  \item{cedifper}{Percent difference in entropy.}
  \item{p}{p-value from Fisher's exact test or the GLMM (as applicable).}
}
}
\description{
Computes marginal, conditional, and information-theoretic
summaries for a binary outcome `y` against one or more predictors in `x`.
Performs either Fisher's exact test or a generalized linear mixed model
(GLMM) for inference.
}
\examples{
pairmiresult = pairmi(misimdata[,2:6])
probstat(misimdata$y,pairmiresult$expanded.data,nfolds=5)
}
